set more off
cd "$dta_files"

use step301_cleanup_ipolate.dta, clear
compress

egen rid=group(nuts country)
label var rid "region id"

drop if year<1969

capture drop _temp_nut1=
gen _temp_nut1=substr(nuts,1,3)

foreach var in ic_EMP_share_female {
		capture drop _xxx
		egen _xxx=mean(`var'), by(year _temp_nut1)

		foreach var1 in DE50 DE60 DEC0 FR10 FR30 {
			replace `var'=_xxx if `var'==. & nuts=="`var1'"
		}
}

capture drop _xxx		
capture drop _temp_nut1		

*============================================================================
*			Merge additional data
*============================================================================

joinby country using "$insheet_files/BW_data_processed.dta", unmatched(master)
tab country _merge
drop _merge

joinby country year using "$insheet_files/BW_IMF_processed.dta", unmatched(master)
tab country _merge
drop _merge

joinby country year using "$insheet_files/EPL_Lazear_processed.dta", unmatched(master)
tab country _merge
drop _merge

drop if country==""
capture drop xxx*

*** create dummies for each country
*** US is the omitted category
egen cid=group(country) if country~="US"
label var cid "country id"
sum cid
local rmax1=r(max)
forvalues i=1(1)`rmax1' {
	gen cid_`i'=(cid==`i')
}
	
*===============================================================================
*				estimation sample
*================================================================================

gen smpl2=.	
replace smpl2 = 1 if nuts==	"AT11"
replace smpl2 = 1 if nuts==	"AT12"
replace smpl2 = 1 if nuts==	"AT13"
replace smpl2 = 1 if nuts==	"AT21"
replace smpl2 = 1 if nuts==	"AT22"
replace smpl2 = 1 if nuts==	"AT31"
replace smpl2 = 1 if nuts==	"AT32"
replace smpl2 = 1 if nuts==	"AT33"
replace smpl2 = 1 if nuts==	"AT34"
replace smpl2 = 1 if nuts==	"BE1"
replace smpl2 = 1 if nuts==	"BE21"
replace smpl2 = 1 if nuts==	"BE22"
replace smpl2 = 1 if nuts==	"BE23"
replace smpl2 = 1 if nuts==	"BE24"
replace smpl2 = 1 if nuts==	"BE25"
replace smpl2 = 1 if nuts==	"BE31"
replace smpl2 = 1 if nuts==	"BE32"
replace smpl2 = 1 if nuts==	"BE33"
replace smpl2 = 1 if nuts==	"BE34"
replace smpl2 = 1 if nuts==	"BE35"
replace smpl2 = 1 if nuts==	"CA: Alberta"
replace smpl2 = 1 if nuts==	"CA: British Columbia"
replace smpl2 = 1 if nuts==	"CA: Manitoba"
replace smpl2 = 1 if nuts==	"CA: New Brunswick"
replace smpl2 = 1 if nuts==	"CA: Newfoundland and Labrador"
replace smpl2 = 1 if nuts==	"CA: Nova Scotia"
replace smpl2 = 1 if nuts==	"CA: Ontario"
replace smpl2 = 1 if nuts==	"CA: Quebec"
replace smpl2 = 1 if nuts==	"CA: Saskatchewan"
replace smpl2 = 1 if nuts==	"CH01"
replace smpl2 = 1 if nuts==	"CH02"
replace smpl2 = 1 if nuts==	"CH03"
replace smpl2 = 1 if nuts==	"CH04"
replace smpl2 = 1 if nuts==	"CH05"
replace smpl2 = 1 if nuts==	"CH06"
replace smpl2 = 1 if nuts==	"CH07"
replace smpl2 = 1 if nuts==	"DE11"
replace smpl2 = 1 if nuts==	"DE12"
replace smpl2 = 1 if nuts==	"DE13"
replace smpl2 = 1 if nuts==	"DE14"
replace smpl2 = 1 if nuts==	"DE21"
replace smpl2 = 1 if nuts==	"DE22"
replace smpl2 = 1 if nuts==	"DE23"
replace smpl2 = 1 if nuts==	"DE24"
replace smpl2 = 1 if nuts==	"DE25"
replace smpl2 = 1 if nuts==	"DE26"
replace smpl2 = 1 if nuts==	"DE27"
replace smpl2 = 1 if nuts==	"DE50"
replace smpl2 = 1 if nuts==	"DE60"
replace smpl2 = 1 if nuts==	"DE71&DE72"
replace smpl2 = 1 if nuts==	"DE73"
replace smpl2 = 1 if nuts==	"DE91&DE92"
replace smpl2 = 1 if nuts==	"DE93"
replace smpl2 = 1 if nuts==	"DE94"
replace smpl2 = 1 if nuts==	"DEA1"
replace smpl2 = 1 if nuts==	"DEA2"
replace smpl2 = 1 if nuts==	"DEA3"
replace smpl2 = 1 if nuts==	"DEA4"
replace smpl2 = 1 if nuts==	"DEA5"
replace smpl2 = 1 if nuts==	"DEB1"
replace smpl2 = 1 if nuts==	"DEB2"
replace smpl2 = 1 if nuts==	"DEB3"
replace smpl2 = 1 if nuts==	"DEC0"
replace smpl2 = 1 if nuts==	"DEF"
replace smpl2 = 1 if nuts==	"DK01"
replace smpl2 = 1 if nuts==	"DK02"
replace smpl2 = 1 if nuts==	"DK03"
replace smpl2 = 1 if nuts==	"DK04"
replace smpl2 = 1 if nuts==	"DK05"
replace smpl2 = 1 if nuts==	"ES11"
replace smpl2 = 1 if nuts==	"ES12"
replace smpl2 = 1 if nuts==	"ES13"
replace smpl2 = 1 if nuts==	"ES21"
replace smpl2 = 1 if nuts==	"ES22"
replace smpl2 = 1 if nuts==	"ES23"
replace smpl2 = 1 if nuts==	"ES24"
replace smpl2 = 1 if nuts==	"ES30"
replace smpl2 = 1 if nuts==	"ES41"
replace smpl2 = 1 if nuts==	"ES42"
replace smpl2 = 1 if nuts==	"ES43"
replace smpl2 = 1 if nuts==	"ES51"
replace smpl2 = 1 if nuts==	"ES52"
replace smpl2 = 1 if nuts==	"ES53"
replace smpl2 = 1 if nuts==	"ES61"
replace smpl2 = 1 if nuts==	"ES62"
replace smpl2 = 1 if nuts==	"FI19"
replace smpl2 = 1 if nuts==	"FI1B"
replace smpl2 = 1 if nuts==	"FI1C"
replace smpl2 = 1 if nuts==	"FI1D"
replace smpl2 = 1 if nuts==	"FR10"
replace smpl2 = 1 if nuts==	"FR21"
replace smpl2 = 1 if nuts==	"FR22"
replace smpl2 = 1 if nuts==	"FR23"
replace smpl2 = 1 if nuts==	"FR24"
replace smpl2 = 1 if nuts==	"FR25"
replace smpl2 = 1 if nuts==	"FR26"
replace smpl2 = 1 if nuts==	"FR30"
replace smpl2 = 1 if nuts==	"FR41"
replace smpl2 = 1 if nuts==	"FR42"
replace smpl2 = 1 if nuts==	"FR43"
replace smpl2 = 1 if nuts==	"FR51"
replace smpl2 = 1 if nuts==	"FR52"
replace smpl2 = 1 if nuts==	"FR53"
replace smpl2 = 1 if nuts==	"FR61"
replace smpl2 = 1 if nuts==	"FR62"
replace smpl2 = 1 if nuts==	"FR63"
replace smpl2 = 1 if nuts==	"FR71"
replace smpl2 = 1 if nuts==	"FR72"
replace smpl2 = 1 if nuts==	"FR81"
replace smpl2 = 1 if nuts==	"FR82&FR83"
replace smpl2 = 1 if nuts==	"ITC1"
replace smpl2 = 1 if nuts==	"ITC2"
replace smpl2 = 1 if nuts==	"ITC3"
replace smpl2 = 1 if nuts==	"ITC4"
replace smpl2 = 1 if nuts==	"ITF1"
replace smpl2 = 1 if nuts==	"ITF2"
replace smpl2 = 1 if nuts==	"ITF3"
replace smpl2 = 1 if nuts==	"ITF4"
replace smpl2 = 1 if nuts==	"ITF5"
replace smpl2 = 1 if nuts==	"ITF6"
replace smpl2 = 1 if nuts==	"ITG1"
replace smpl2 = 1 if nuts==	"ITH1&ITH2"
replace smpl2 = 1 if nuts==	"ITH3"
replace smpl2 = 1 if nuts==	"ITH4"
replace smpl2 = 1 if nuts==	"ITH5"
replace smpl2 = 1 if nuts==	"ITI1"
replace smpl2 = 1 if nuts==	"ITI2"
replace smpl2 = 1 if nuts==	"ITI3"
replace smpl2 = 1 if nuts==	"ITI4"
replace smpl2 = 1 if nuts==	"NL11"
replace smpl2 = 1 if nuts==	"NL12"
replace smpl2 = 1 if nuts==	"NL13"
replace smpl2 = 1 if nuts==	"NL21&NL23"
replace smpl2 = 1 if nuts==	"NL22"
replace smpl2 = 1 if nuts==	"NL31"
replace smpl2 = 1 if nuts==	"NL32"
replace smpl2 = 1 if nuts==	"NL33"
replace smpl2 = 1 if nuts==	"NL34"
replace smpl2 = 1 if nuts==	"NL41"
replace smpl2 = 1 if nuts==	"NL42"
replace smpl2 = 1 if nuts==	"SE11"
replace smpl2 = 1 if nuts==	"SE12"
replace smpl2 = 1 if nuts==	"SE21"
replace smpl2 = 1 if nuts==	"SE22"
replace smpl2 = 1 if nuts==	"SE23"
replace smpl2 = 1 if nuts==	"SE31"
replace smpl2 = 1 if nuts==	"SE32"
replace smpl2 = 1 if nuts==	"SE33"
replace smpl2 = 1 if nuts==	"UKC1"
replace smpl2 = 1 if nuts==	"UKC2"
replace smpl2 = 1 if nuts==	"UKD1"
replace smpl2 = 1 if nuts==	"UKD3"
replace smpl2 = 1 if nuts==	"UKD4"
replace smpl2 = 1 if nuts==	"UKD6"
replace smpl2 = 1 if nuts==	"UKD7"
replace smpl2 = 1 if nuts==	"UKE1"
replace smpl2 = 1 if nuts==	"UKE2"
replace smpl2 = 1 if nuts==	"UKE3"
replace smpl2 = 1 if nuts==	"UKE4"
replace smpl2 = 1 if nuts==	"UKF1"
replace smpl2 = 1 if nuts==	"UKF2"
replace smpl2 = 1 if nuts==	"UKF3"
replace smpl2 = 1 if nuts==	"UKG1"
replace smpl2 = 1 if nuts==	"UKG2"
replace smpl2 = 1 if nuts==	"UKG3"
replace smpl2 = 1 if nuts==	"UKH1"
replace smpl2 = 1 if nuts==	"UKH2"
replace smpl2 = 1 if nuts==	"UKH3"
replace smpl2 = 1 if nuts==	"UKI1"
replace smpl2 = 1 if nuts==	"UKI2"
replace smpl2 = 1 if nuts==	"UKJ1"
replace smpl2 = 1 if nuts==	"UKJ2"
replace smpl2 = 1 if nuts==	"UKJ3"
replace smpl2 = 1 if nuts==	"UKJ4"
replace smpl2 = 1 if nuts==	"UKK1"
replace smpl2 = 1 if nuts==	"UKK2"
replace smpl2 = 1 if nuts==	"UKK3"
replace smpl2 = 1 if nuts==	"UKK4"
replace smpl2 = 1 if nuts==	"UKL1"
replace smpl2 = 1 if nuts==	"UKL2"
replace smpl2 = 1 if nuts==	"UKM2"
replace smpl2 = 1 if nuts==	"UKM3"
replace smpl2 = 1 if nuts==	"UKM5"
replace smpl2 = 1 if nuts==	"UKM6"
replace smpl2 = 1 if nuts==	"US: AL"
replace smpl2 = 1 if nuts==	"US: AR"
replace smpl2 = 1 if nuts==	"US: AZ"
replace smpl2 = 1 if nuts==	"US: CA"
replace smpl2 = 1 if nuts==	"US: CO"
replace smpl2 = 1 if nuts==	"US: CT"
replace smpl2 = 1 if nuts==	"US: DE"
replace smpl2 = 1 if nuts==	"US: FL"
replace smpl2 = 1 if nuts==	"US: GA"
replace smpl2 = 1 if nuts==	"US: IA"
replace smpl2 = 1 if nuts==	"US: ID"
replace smpl2 = 1 if nuts==	"US: IL"
replace smpl2 = 1 if nuts==	"US: IN"
replace smpl2 = 1 if nuts==	"US: KS"
replace smpl2 = 1 if nuts==	"US: KY"
replace smpl2 = 1 if nuts==	"US: LA"
replace smpl2 = 1 if nuts==	"US: MA"
replace smpl2 = 1 if nuts==	"US: MD"
replace smpl2 = 1 if nuts==	"US: ME"
replace smpl2 = 1 if nuts==	"US: MI"
replace smpl2 = 1 if nuts==	"US: MN"
replace smpl2 = 1 if nuts==	"US: MO"
replace smpl2 = 1 if nuts==	"US: MS"
replace smpl2 = 1 if nuts==	"US: MT"
replace smpl2 = 1 if nuts==	"US: NC"
replace smpl2 = 1 if nuts==	"US: ND"
replace smpl2 = 1 if nuts==	"US: NE"
replace smpl2 = 1 if nuts==	"US: NH"
replace smpl2 = 1 if nuts==	"US: NJ"
replace smpl2 = 1 if nuts==	"US: NM"
replace smpl2 = 1 if nuts==	"US: NV"
replace smpl2 = 1 if nuts==	"US: NY"
replace smpl2 = 1 if nuts==	"US: OH"
replace smpl2 = 1 if nuts==	"US: OK"
replace smpl2 = 1 if nuts==	"US: OR"
replace smpl2 = 1 if nuts==	"US: PA"
replace smpl2 = 1 if nuts==	"US: RI"
replace smpl2 = 1 if nuts==	"US: SC"
replace smpl2 = 1 if nuts==	"US: SD"
replace smpl2 = 1 if nuts==	"US: TN"
replace smpl2 = 1 if nuts==	"US: TX"
replace smpl2 = 1 if nuts==	"US: UT"
replace smpl2 = 1 if nuts==	"US: VA"
replace smpl2 = 1 if nuts==	"US: VT"
replace smpl2 = 1 if nuts==	"US: WA"
replace smpl2 = 1 if nuts==	"US: WI"
replace smpl2 = 1 if nuts==	"US: WV"
replace smpl2 = 1 if nuts==	"US: WY"

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*	normalize GDP p.c. to PPP
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
capture drop logY_ppp*

joinby country using "$insheet_files/penn_world_tables_71.dta", unmatched(master)
tab country _merge
drop _merge

	capture drop temp_country
	egen temp_country=group(country)
	sum temp_country
	local max1=r(max)
	capture drop gdp_per_capita_PPP
	gen gdp_per_capita_PPP=.
	quiet forvalues i =1(1)`max1' {
		forvalues yy=1970(1)1975 {
			sum gdp_per_capita [aw = age_total] if year==`yy' & temp_country==`i' & smpl2==1
			local mean0=r(mean)
			sum pwt71_cgdp if year==`yy' & temp_country==`i'& smpl2==1
			local mean1=r(mean)
			replace gdp_per_capita_PPP=gdp_per_capita*`mean1'/`mean0' if temp_country==`i' & year==`yy' & smpl2==1
		}
		
	}
	drop temp_country


	capture drop logY_ppp
	gen logY_ppp=log(gdp_per_capita_PPP)*100
	label var logY_ppp "log GDP per capita, PPP (PWT)"		

compress

*========================================================
* nuts dominated by cities
*========================================================

gen capital=0 
replace capital = 1 if nuts=="AT13"
replace capital = 1 if nuts=="BE1"
replace capital = 1 if nuts=="BE10"
replace capital = 1 if nuts=="CA: Ontario"
replace capital = 1 if nuts=="CH02"
replace capital = 1 if nuts=="DE3"
replace capital = 1 if nuts=="DE30"
replace capital = 1 if nuts=="DK01"
replace capital = 1 if nuts=="ES3"
replace capital = 1 if nuts=="ES30"
replace capital = 1 if nuts=="FI1B"
replace capital = 1 if nuts=="FR1"
replace capital = 1 if nuts=="FR10"
replace capital = 1 if nuts=="ITI4"
replace capital = 1 if nuts=="NL32"
replace capital = 1 if nuts=="SE11"
replace capital = 1 if nuts=="UKI"
replace capital = 1 if nuts=="UKI1"
replace capital = 1 if nuts=="UKI1"
replace capital = 1 if nuts=="UKI2"
replace capital = 1 if nuts=="US: DC"
replace capital = 1 if nuts=="US: South Atlantic"

gen city_nuts=0 
replace city_nuts = 1 if nuts=="AT13"
replace city_nuts = 1 if nuts=="BE1"
replace city_nuts = 1 if nuts=="BE10"
replace city_nuts = 1 if nuts=="DE3" 
replace city_nuts = 1 if nuts=="DE30"
replace city_nuts = 1 if nuts=="DE5"
replace city_nuts = 1 if nuts=="DE50"
replace city_nuts = 1 if nuts=="DE6"
replace city_nuts = 1 if nuts=="DE60"
replace city_nuts = 1 if nuts=="DK01"
replace city_nuts = 1 if nuts=="ES3"
replace city_nuts = 1 if nuts=="ES30"
replace city_nuts = 1 if nuts=="FR1"
replace city_nuts = 1 if nuts=="FR10"
replace city_nuts = 1 if nuts=="UKI"
replace city_nuts = 1 if nuts=="UKI1"
replace city_nuts = 1 if nuts=="UKI2" 
replace city_nuts = 1 if nuts=="US: DC" 

drop if nuts=="FR82"

sum ue2_hyst if nuts=="DEF0"
replace ue2_hyst=r(mean) if nuts=="DEF"

save wf_step1001, replace


